# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

# Somehow this fixes the docs when built on readthedocs?
import os
import sys
sys.path.insert(0, os.path.abspath('..'))


project = 'EncodingInformation'
copyright = '2024, anon'
author = 'anon'

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ["sphinx.ext.autodoc", "sphinx.ext.napoleon", "nbsphinx", "sphinxcontrib.googleanalytics"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# this is needed for read the docs
master_doc = "index"

# dont look for errors in notebook cells
nbsphinx_allow_errors = True

# make sure it can build without the package installed
autodoc_mock_imports = ["bsccm", "dask", "h5py", "tensorflow"]


# this is to make constructor docstrings show up
autoclass_content = "both"

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"
html_theme_options = {
    'collapse_navigation': True,
    'navigation_depth': 10,
}

html_title = "Documentation"


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ["_static"]

# Prevent nbsphinx from executing the notebooks
nbsphinx_execute = 'never'


googleanalytics_id = 'G-D3MD1M6S63'  
googleanalytics_enabled = True